/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DescriptorLayer.cpp                                                *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              05/05/2007       1.0                              *
* Carlos Grossy              17/05/2007       1.1                              *
* Carlos Grossy              14/06/2007       1.2                              *
*******************************************************************************/

#include "DescriptorLayer.h"

descriptorLayer::descriptorLayer() {

    itemIn ein;
    itemOut eout;
    int cantb, cantd, *iserial;
    //int id;
    dscEndpoint *endp;

    l = log::instance();

    #ifdef _DRIVER_MICROCHIP
        dl = new driverLayerMCHP();
    #endif
    #ifdef _DRIVER_LIBUSB
        dl = new driverLayerLibUsb();
    #endif
    #ifdef _DRIVER_LIBUSBWIN32
        dl = new driverLayerLibUsbWin32();
    #endif
    #ifdef _DRIVER_CUSTOM
    #endif

    iserial = dl->getU4ABoards(cantb);
    // Inicializo el mapa SerialNumber -> IdBoard
    for (int i = 0; i < cantb ; i++) {
        serials.insert(pair<int,int>(iserial[i],i));
    };
    delete [] iserial;
    // Cargo los tipos de descriptores de cada placa detectada.
    for (int i = 0; i < cantb ; i++) {
        cantd = dl->qtyDsc(i);
        for (int j = 0 ; j < cantd ; j++) {
            endp = dl->getEndpointDsc(i, j);
            if (endp->tdscin != NULL_IN) {
                ein.dsc = endp->epnum;
                ein.tin = endp->tdscin;
                ein.cantAsignados = 0;
                ein.buffer = dl->open(i, ein.dsc, ein.tin);
                dscIn.insert(pair<int,itemIn>(i,ein));
            }
            else {
                eout.dsc = endp->epnum;
                eout.tout = endp->tdscout;
                eout.cantAsignados = 0;
                eout.buffer = dl->open(i, eout.dsc, eout.tout);
                dscOut.insert(pair<int,itemOut>(i,eout));
            };
            delete endp;
        };
    };

    //serials.insert(pair<int,int>(0,0));
    //serials.insert(pair<int,int>(12345678,1));
    // Placa 0
    //id = 0;
    // Endpoint 1 IN
    //ein.dsc = U4ADSC;
    //ein.tin = INT_IN;
    //ein.cantAsignados = 0;
    //ein.buffer = dl->open(id, U4ADSC, INT_IN);
    //dscIn.insert(pair<int,itemIn>(id,ein));

    // Endpoint 1 OUT
    //eout.dsc = U4ADSC;
    //eout.tout = INT_OUT;
    //eout.cantAsignados = 0;
    //eout.buffer = dl->open(id, U4ADSC, INT_OUT);
    //dscOut.insert(pair<int,itemOut>(id,eout));

    // Endpoint 2 IN
    //ein.dsc = 2;
    //ein.tin = BULK_IN;
    //ein.cantAsignados = 0;
    //ein.buffer = dl->open(id, 2, BULK_IN);
    //dscIn.insert(pair<int,itemIn>(id,ein));

    // Endpoint 2 OUT
    //eout.dsc = 2;
    //eout.tout = BULK_OUT;
    //eout.cantAsignados = 0;
    //eout.buffer = dl->open(id, 2, BULK_OUT);
    //dscOut.insert(pair<int,itemOut>(id,eout));

    // Placa 1
    //id = 1;
    // Endpoint 1 IN
    //ein.dsc = U4ADSC;
    //ein.tin = INT_IN;
    //ein.cantAsignados = 0;
    //ein.buffer = dl->open(id, U4ADSC, INT_IN);
    //dscIn.insert(pair<int,itemIn>(id,ein));

    // Endpoint 1 OUT
    //eout.dsc = U4ADSC;
    //eout.tout = INT_OUT;
    //eout.cantAsignados = 0;
    //eout.buffer = dl->open(id, U4ADSC, INT_OUT);
    //dscOut.insert(pair<int,itemOut>(id,eout));

    // Endpoint 2 IN
    //ein.dsc = 2;
    //ein.tin = BULK_IN;
    //ein.cantAsignados = 0;
    //ein.buffer = dl->open(id, 2, BULK_IN);
    //dscIn.insert(pair<int,itemIn>(id,ein));

    // Endpoint 2 OUT
    //eout.dsc = 2;
    //eout.tout = BULK_OUT;
    //eout.cantAsignados = 0;
    //eout.buffer = dl->open(id, 2, BULK_OUT);
    //dscOut.insert(pair<int,itemOut>(id,eout));
}

descriptorLayer::~descriptorLayer() {

    multimap<int,itemIn>::iterator it1;
    multimap<int,itemOut>::iterator it2;

    l->printLog("descriptorLayer Destructor",true,true);
    l = NULL;

    for (it1 = dscIn.begin() ; it1 != dscIn.end(); it1++ ) {
        dl->close(it1->second.buffer);
    };
    for (it2 = dscOut.begin() ; it2 != dscOut.end(); it2++ ) {
        dl->close(it2->second.buffer);
    };
    delete dl;
}

int descriptorLayer::requestDscIn(int serial, usbin tdsc) {

    multimap<int,itemIn>::iterator it;
    int board;

    board = getBoard(serial);
    for (it = dscIn.begin() ; it != dscIn.end(); it++ ) {
        if (it->first == board) {
            if (it->second.tin == tdsc) {
                it->second.cantAsignados =+ 1;
                return it->second.dsc;
            };
        };
    };
    return 255; // usa los define de error.
}

int descriptorLayer::requestDscOut(int serial, usbout tdsc) {

    multimap<int,itemOut>::iterator it;
    int board;

    board = getBoard(serial);
    for (it = dscOut.begin() ; it != dscOut.end(); it++ ) {
        if (it->first == board) {
            if (it->second.tout == tdsc) {
                it->second.cantAsignados =+ 1;
                return it->second.dsc;
            };
        };
    };
    return 255; // usar los define de error.
}

void descriptorLayer::freeDscIn(int board, int dsc) {

    multimap<int,itemIn>::iterator it;

    for (it = dscIn.begin() ; it != dscIn.end(); it++ ) {
        if ((it->first == board) && (it->second.dsc == dsc) && (it->second.cantAsignados > 0)) {
            it->second.cantAsignados =- 1;
            break;
        };
    };
}

void descriptorLayer::freeDscOut(int board, int dsc) {

    multimap<int,itemOut>::iterator it;

    for (it = dscOut.begin() ; it != dscOut.end(); it++ ) {
        if ((it->first == board) && (it->second.dsc == dsc) && (it->second.cantAsignados > 0)) {
            it->second.cantAsignados =- 1;
            break;
        };
    };
}

int descriptorLayer::getBufferIn(int board, int dsc) {

    multimap<int,itemIn>::iterator it;

    for (it = dscIn.begin();it != dscIn.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.buffer;
        };
    };
    return 255; // ERROR
}

int descriptorLayer::getBufferOut(int board, int dsc) {

    multimap<int,itemOut>::iterator it;

    for (it = dscOut.begin();it != dscOut.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.buffer;
        };
    };
    return 255; // ERROR
}

usbin descriptorLayer::getTypeDscIn(int board, int dsc) {

    multimap<int,itemIn>::iterator it;

    for (it = dscIn.begin(); it != dscIn.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.tin;
        };
    };
    return NULL_IN;
}

usbout descriptorLayer::getTypeDscOut(int board, int dsc) {

    multimap<int, itemOut>::iterator it;

    for (it = dscOut.begin(); it != dscOut.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.tout;
        };
    };
    return NULL_OUT;
}

bool descriptorLayer::send(int board, int dsc, char *msg, int nlen, int timeout) {

    int nbuff = getBufferOut(board, dsc);
    usbout tout = getTypeDscOut(board, dsc);

    switch (tout) {
        case BULK_OUT:
            return dl->sendBulk(nbuff, msg, nlen, timeout);
            break;
        case CTRL_OUT:
            return dl->sendCtrl(nbuff, msg, nlen, timeout);
            break;
        case INT_OUT:
            return dl->sendInt(nbuff, msg, nlen, timeout);
            break;
        case ISO_OUT:
            return dl->sendIso(nbuff, msg, nlen, timeout);
            break;
        case NULL_OUT:
            return false;
            break;
     };
     return false;
}

char* descriptorLayer::receive(int board, int dsc, int& recv, bool& ok, int timeout) {

    int nbuff = getBufferIn(board, dsc);
    usbin tin = getTypeDscIn(board, dsc);

    switch (tin) {
        case BULK_IN:
            return dl->receiveBulk(nbuff, recv, ok, timeout);
            break;
        case CTRL_IN:
            return dl->receiveCtrl(nbuff, recv, ok, timeout);
            break;
        case INT_IN:
            return dl->receiveInt(nbuff, recv, ok, timeout);
            break;
        case ISO_IN:
            return dl->receiveIso(nbuff, recv, ok, timeout);
            break;
        case NULL_IN:
            return NULL;
            break;
    };
    return NULL;
}

int * descriptorLayer::getU4ABoards(int &cant) {

    map<int,int>::iterator it;
    int *boards;

    cant = serials.size();
    boards = new int[cant];
    for (it = serials.begin(); it != serials.end();it++) {
        boards[it->second] = it->first;
    };

    return boards;
}

int descriptorLayer::getBoard(int serial) {

    map<int,int>::iterator it;

    it = serials.find(serial);
    return (it->second);
}

int descriptorLayer::getSerial(int board) {

    map<int,int>::iterator it;
    int res = 0;

    for (it = serials.begin(); it != serials.end(); it++) {
        if (it->second == board) {
            res = (int) it->first;
            break;
        }
    }
    return res;
}
